/** @file   particlesparks.cpp
 * @brief   Implementation of ParticleSparks - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "particlesparks.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================

int ParticleSparks::s_averageLifetime = 10;


///
/// Constructors, destructor and operators
/// ======================================

/** Constructor
 */
ParticleSparks::ParticleSparks( const Vec2D& rP, const Vec2D& rD, int num ) :
  ParticleSystem()
{
  Vec2D normDir( rD );
  normDir.norm();
  float s = rD.length() / 3.0;
  
  for ( int i=0; i < num; i++ ) {
    Particle* pP = new Particle();
    pP->m_pos = rP;
    pP->lifetime( s_averageLifetime + rand() % 10 );
    pP->m_grad = Gradient( Color(120,90,30), Color(170,150,80),
                           Color(230,230,180), 70 );
    pP->m_size = 1;
    pP->m_friction = 0.7;
    
    pP->m_dirVec = normDir;
    pP->m_dirVec *= s + ( static_cast<float>( rand() % 100 ) / 100.0 );
    pP->m_dirVec.rotate( (rand() % 200) - 100 );
    
    this->addParticle( pP );
  }
}



/** Destructor
 */
ParticleSparks::~ParticleSparks()
{
}

} // end of namespace
